Type Story_Option_Type

	AS String Key = ""

	As Long Dest = 0, Req = 0

	AS String Caption = ""

End Type

Type Story_Page_Type

	As Long Index = 0, History = 0, Visited = 0

	As String Caption = ""

	AS Long A = 0, B = 0

	As String Sprite = ""

	ReDim As Story_Option_Type Options ( Any )

	ReDim As String Desc ( Any )

End Type

ReDim Shared As Story_Page_Type Pages ( Any )

Declare Sub Page_Create ( Page ( Any ) As Story_Page_Type, Filename As String )

Declare Sub Page_Destroy ( Page ( Any ) As Story_Page_Type, PageIndex As Long = 0 )

Declare Sub Load_Pages ( Pages ( Any ) As Story_Page_Type )

Declare Sub Render_Frame ( ByRef Page As Story_Page_Type )

Declare Sub Render_Page ( ByRef Page As Story_Page_Type )

Declare Function Navigate_Page ( ByRef Page As Story_Page_Type, C As String = "" ) As Long

Declare Sub Render_Text ( ByRef Page As Story_Page_Type, ByRef Dest As FB.Image Ptr, Textdata As String = "", Col As Long = 1, Row As Long = 1, Stroke_Color As Long = &HFF7030FF )

Declare Sub Cat ( Files ( Any ) As String, Path As String = ".\*.*" )

Declare Function Waitkey ( ) As String

Declare Sub CLS2 ( ByRef Source As FB.Image Ptr, Fill As Long = 0 )

Declare Sub Render_Scroll ( ByRef Page As Story_Page_Type, TextData As String = "", ByRef Disp As FB.Image Ptr, Col As Long = 1, Row As Long = 1, Stroke_Color As Long = &HFF7030FF )

Declare Function GamePercent ( PageLocation As Long = 0, ByRef Total As Long, ByRef Tally As Long, ByRef Turns As Long ) As String

Declare Sub GameGallery ( )

Sub Page_Create ( Page ( Any ) As Story_Page_Type, Filename As String = "000.seq" )

	Dim As Long PageIndex = ValInt ( Ext_Prefix ( ".", Filename ) )

	If Not Is_File ( ".\" & ProjectSpace & "\Assets\Pages\" & Filename ) Then

		Color RGBA ( 255, 255, 255, 255 )

		Print "Is not a file: " & Chr ( 34 ) & ".\" & ProjectSpace & "\Assets\Pages\" & Filename & Chr ( 34 )

		Flip

		QuickSleep ( )

		Exit Sub

	End If

	Dim As Long Filemode = Freefile

	If Filemode = 0 Then

		Exit Sub

	End If

	If Open ( ".\" & ProjectSpace & "\Assets\Pages\" & Filename For Input As #Filemode ) Then

		Close #Filemode

		Filemode = 0

		Exit Sub

	End If

	If UBound ( Page ) < PageIndex Then

		ReDim Preserve Page ( 0 To PageIndex )

	End If

	Page ( PageIndex ).Index = PageIndex

	Input #Filemode, Page ( PageIndex ).Caption

	Input #Filemode, _
	Page ( PageIndex ).A, _
	Page ( PageIndex ).B, _
	Page ( PageIndex ).Sprite

	ReDim ( Page ( PageIndex ).Options ) ( 1 to 4 )

	Dim As Long Index = 0

	For Index = 1 to 4 Step 1

		Input #Filemode, _
		Page ( PageIndex ).Options ( Index ).Key, _
		Page ( PageIndex ).Options ( Index ).Dest, _
		Page ( PageIndex ).Options ( Index ).Req, _
		Page ( PageIndex ).Options ( Index ).Caption

	Next Index

	ReDim ( Page ( PageIndex ).Desc ) ( 1 to 4 )

	For Index = 1 to 4 Step 1

		Input #Filemode, Page ( PageIndex ).Desc ( Index )

	Next Index

	Close #Filemode

	Filemode = 0

End Sub

Sub Page_Destroy ( Page ( Any ) As Story_Page_Type, PageIndex As Long = 0 )

	Page ( PageIndex ).Caption = ""

	Page ( PageIndex ).A = 0

	Page ( PageIndex ).B = 0

	Page ( PageIndex ).Sprite = ""

	erase Page ( PageIndex ).Options

	erase Page ( PageIndex ).Desc

End Sub

Sub Load_Pages ( Pages ( Any ) As Story_Page_Type )

	ReDim Files ( Any ) As String

	Dim As Long Index = 0

	Cat ( Files ( ), ".\" & ProjectSpace & "\Assets\Pages\*.seq" )

	IF LBound ( Files ) = 0 And Ubound ( Files ) = - 1 Then

		Color RGBA ( 255, 255, 255, 255 )

		Print "Oh Noes! No files to be found!"

		Erase Pages

	Else

		Erase Pages

		For Index = LBound ( Files ) To Ubound ( Files ) Step 1

			/'
			Color RGBA ( 255, 255, 255, 255 )

			Print Files ( Index )
			'/

			Page_Create ( Pages ( ), Files ( Index ) )

		Next Index

	End If

	/'
	Flip
	QuickSleep ( )
	'/
	
End sub

Sub Render_Frame ( ByRef Page As Story_Page_Type )

	Dim As FB.Image Ptr Backdrop

	Dim As String Backdrop_Image = ".\" & ProjectSpace & "\Assets\Sprites\" & "background" & ".png"

	If Is_File ( Backdrop_Image ) Then

		Backdrop = LoadRGBAFile ( Backdrop_Image )

	Else

		Backdrop = ImageCreate ( 64, 64, RGBA ( 0, 0, 0, 0 ), 32 )

	End If

	Dim As FB.Image Ptr Source

	Dim As String Source_Image = ".\" & ProjectSpace & "\Assets\Sprites\" & Page.Sprite & ".png"

	If Is_File ( Source_Image ) Then

		Source = LoadRGBAFile ( Source_Image )

	Else

		Source = ImageCreate ( 64, 64, RGBA ( 0, 0, 0, 0 ), 32 )

	End If

	Gfx_Buffer_Repeat ( Backdrop, DispOut ( Page.Index, Pg_Background ) )

	Gfx_Buffer_Stretch_Aspect ( Source, DispOut ( Page.Index, Pg_Illustration ) )

	ImageDestroy Backdrop

	ImageDestroy Source

	Exit Sub

End Sub

Sub Render_Page ( ByRef Page As Story_Page_Type )

	Dim as Long Index = 0
	
	Dim As String Caption = ""

	For Index = 1 to 4 Step 1

		If Len ( Caption ) > 0 and Len ( Page.Desc ( Index ) ) > 0 Then
			
			Caption & = " "
		
		End If
		
		Caption & = Page.Desc ( Index )

	Next Index
	
	Render_Scroll ( Page, Caption, DispOut ( Page.Index, Pg_Description ), 1, 1, RGBA ( 255, 255, 255, 255 ) )

	Caption = ""
	
	For Index = 1 to 4 Step 1

		If Len ( Page.Options ( Index ).Caption ) > 0 Then
		
			Select Case Sgn ( Page.Options ( Index ).Req )
			Case 0
				
				If Len ( Caption ) > 0 and Len ( Page.Options ( Index ).Caption ) > 0 Then
				
					Caption & = " "
		
				End If
				
				If Len ( Page.Options ( Index ).Caption ) > 0 Then
					
					If Page.Options ( Index ).Key = Space ( 1 ) Then
						Caption & = "<SPACE>"
					Else
						Caption & = "<" & UCase ( Page.Options ( Index ).Key ) & ">"
					End If
					
					
					Caption & = Page.Options ( Index ).Caption
						
				End If

			case 1
				
				If Pages ( Page.Options ( Index ).Req ).History > 0 Then
					
					If Len ( Caption ) > 0 and Len ( Page.Options ( Index ).Caption ) > 0 Then
				
						Caption & = " "
					
					End If
			
					If Len ( Page.Options ( Index ).Caption ) > 0 Then
					
						If Page.Options ( Index ).Key = Space ( 1 ) Then
							Caption & = "<SPACE>"
						Else
							Caption & = "<" & UCase ( Page.Options ( Index ).Key ) & ">"
						End If
			
						Caption & = Page.Options ( Index ).Caption
						
					End If
				
				End If
				
			case - 1
				
				If Pages ( Abs ( Page.Options ( Index ).Req ) ).History = 0 Then
					
					If Len ( Caption ) > 0 and Len ( Page.Options ( Index ).Caption ) > 0 Then
				
						Caption & = " "
		
					End If

					If Len ( Page.Options ( Index ).Caption ) > 0 Then
						
						If Page.Options ( Index ).Key = Space ( 1 ) Then
							Caption & = "<SPACE>"
						Else
							Caption & = "<" & UCase ( Page.Options ( Index ).Key ) & ">"
						End If
			
						Caption & = Page.Options ( Index ).Caption
						
					End If
					
				End If

			End Select

		End If
		
	Next Index

	Render_Text Page, DispOut ( Page.Index, Pg_Caption ), Page.Caption, ( ( DispOut ( Page.Index, Pg_Caption ) - > Width - Len ( Page.Caption ) Shl 3 ) Shr 3 ) \ 2 + 1, 1, RGBA ( 255, 255, 255, 255 )

	Render_Scroll ( Page, Caption, DispOut ( Page.Index, Pg_Options ), 1, 1, RGBA ( 255, 255, 255, 255 ) )

	Exit Sub

End Sub

Function Navigate_Page ( ByRef Page As Story_Page_Type, C As String = "" ) As Long

	Dim as Long Index = 0
	
	If C = "" Then
		
		If Page.History = 0 Then
			Page.History + = 1
		End If
		
		Return Page.Index
	
	End If
			
	For Index = 1 to 4 Step 1

		Select Case Sgn ( Page.Options ( Index ).Req )
		Case 0
			
			If LCase ( C ) = LCase ( Page.Options ( Index ).Key ) Then
				
				If Setting_Turn Then
					Page.History + = 1
				End If
				Return Page.Options ( Index ).Dest

			End If
				
		case 1
				
			If Pages ( Page.Options ( Index ).Req ).History > 0 Then
					
				If LCase ( C ) = LCase ( Page.Options ( Index ).Key ) Then
					
					If Setting_Turn Then
						Page.History + = 1
					End If
					Return Page.Options ( Index ).Dest

				End If
				
			End If
				
		case - 1
				
			If Pages ( Abs ( Page.Options ( Index ).Req ) ).History = 0 Then
					
				If LCase ( C ) = LCase ( Page.Options ( Index ).Key ) Then
					
					If Setting_Turn Then
						Page.History + = 1
					End If
					Return Page.Options ( Index ).Dest
						
				End If
				
					
			End If

		End Select
		
	Next Index

	Return Page.Index

End Function

Sub Render_Text ( ByRef Page As Story_Page_Type, ByRef Dest As FB.Image Ptr, Textdata As String = "", Col As Long = 1, Row As Long = 1, Stroke_Color As Long = &HFF7030FF )

	Dim As FB.Image Ptr FONTCOLOR

	FONTCOLOR = ImageCreate ( FONTSHEET - > Width, FONTSHEET - > Height, RGBA ( 0, 0, 0, 0 ), 32 )

	Line FONTCOLOR, ( 0, 0 ) - ( FONTCOLOR - > Width - 1, FONTCOLOR - > Height - 1 ), Stroke_Color, BF

	Put FONTCOLOR, ( 0, 0 ), FONTSHEET, And

	Dim As Long Xo = Col, Yo = Row , Zo = 0

	Dim As Long Xa = 0, Ya = 0, Za = 0

	Yo = ( Row - 1 ) Shl 3

	For Zo = 1 to Len ( TextData ) Step 1

		Za = Asc ( Mid ( TextData, Zo, 1 ) )

		Xo = ( Col + Zo - 1 ) Shl 3

		Xa = ( Za Mod 16 ) Shl 3

		Ya = ( Za \ 16 ) Shl 3

		put Dest, ( Xo, Yo ), FONTCOLOR, ( Xa, Ya ) - step ( 7, 7 ), Alpha

	Next Zo

	ImageDestroy ( FONTCOLOR )

End Sub

Sub Cat ( Files ( Any ) As String, Path As String = ".\*.*" )

	Erase Files

	'Print "Cat: " & Chr ( 34 ) & Path & Chr ( 34 )

	Dim As String sFile

	sFile = Dir ( Path )

	Do While Len ( sFile ) > 0

		'Print "sFile: " & Chr ( 34 ) & sFile & Chr ( 34 )

		If LBound ( Files ) = 0 AndAlso UBound ( Files ) = - 1 Then

			ReDim Files ( 0 to 0 )

		Else

			ReDim Preserve Files ( 0 To UBound ( Files ) + 1 )

		End If

		Files ( UBound ( Files ) ) = sFile

		sFile = Dir ( )

	Loop

	'Print "Cat found " & ( UBound ( Files ) + 1 ) & " files."

End Sub

Function Waitkey ( ) As String

	Dim As String C = ""

	Do While Len ( C ) = 0

		C = InKey ( )

		QuickSleep ( )

	Loop

	If C = Chr ( 27 ) Then

		Screen 0

		End

	End If

	Return C

End Function

Sub CLS2 ( ByRef Source As FB.Image Ptr, Fill As Long = 0 )

	Line Source, ( 0, 0 ) - ( Source - > Width - 1, Source - > Height - 1 ), Fill, BF

End Sub

Sub Render_Scroll ( ByRef Page As Story_Page_Type, TextData As String = "", ByRef Disp As FB.Image Ptr, Col As Long = 1, Row As Long = 1, Stroke_Color As Long = &HFF7030FF )

	Dim As String OutBuffer = "", ReserveBuffer = ""
		
	OutBuffer = ""
	ReserveBuffer = TextData
	
	Dim As Long W = ( Disp - > Width Shr 3 ) + 1, H = ( Disp - > Height Shr 3 ) + 1
		
	ReserveBuffer = Str_Replace ( Space ( 2 ), Space ( 1 ), ReserveBuffer )

	Do While Len ( ReserveBuffer ) > 0
	
		OutBuffer & = Prefix ( CRLF, ReserveBuffer )
		ReserveBuffer = Suffix ( CRLF, ReserveBuffer )
		
		Trim ( OutBuffer )
		
		Do While Len ( OutBuffer ) > = W
		
			Select Case StrPos ( Space ( 1 ), OutBuffer )
			Case Is > 0
			
				ReserveBuffer = Ext_Suffix ( Space ( 1 ), OutBuffer ) & Space ( 1 ) & ReserveBuffer
				OutBuffer = Ext_Prefix ( Space ( 1 ), OutBuffer )
			
			Case 0
			
				ReserveBuffer = " - " & Mid ( OutBuffer, W + 1 ) & ReserveBuffer
				OutBuffer = Left ( OutBuffer, W )
			
			End Select
			
		Loop
		
		Col = ( W - Len ( OutBuffer ) ) \ 2
		
		Render_Text Page, Disp, OutBuffer, Col, Row, Stroke_Color
		
		OutBuffer = ""
		
		Row + = 1
		
	Loop
	
End Sub

Function GamePercent ( PageLocation As Long = 0, ByRef Total As Long, ByRef Tally As Long, ByRef Turns As Long ) As String
	
	Dim As Long Index = 0
	
	Total = 0
	Index = 0
	Tally = 0
	Turns = 0
	
	Dim As String Score = ""
	
	Total = UBound ( Pages ) - LBound ( pages ) + 1
	
	For Index = LBound ( Pages ) To UBound ( Pages ) Step 1
		
		If PageLocation = 0 Then
			Pages ( Index ).History = 0
		End If
		
		If Pages ( Index ).History > 0 Then
			Tally + = 1
			Turns + = Pages ( Index ).History
		End If
		
	Next Index
	
	Score = Right ( String ( 5, "0" ) & Str ( Tally * 10000 \ Total ), 5 )
	
	Score = Left ( Score, 3 ) & "." & Right ( Score, 2 ) & "%"
	
	Return Score
	
End Function

Sub GameGallery ( )
	
	Dim As FB.Image Ptr Intermediary
	
	If DispOut ( 0, Pg_Gallery ) <> 0 Then
		ImageDestroy ( DispOut ( 0, Pg_Gallery ) )
	End If
	
	DispOut ( 0, Pg_Gallery ) = ImageCreate ( DispOut ( 0, Pg_Intermediary ) - > Width, DispOut ( 0, Pg_Intermediary ) - > Height, RGBA ( 0, 0, 0, 0 ), 32 )
	
	Dim As Long Index = 0, Xo = 0, Yo = 0
		
	For Index = LBound ( Pages ) To UBound ( Pages ) Step 1
		
		If Pages ( Index ).History = 0 Then Continue For
		
		If DispOut ( Index, Pg_Thumbnail ) = 0 Then
		
			DispOut ( Index, Pg_Thumbnail ) = ImageCreate ( 24, 24, RGBA ( 0, 0, 0, 0 ), 32 )

			Intermediary = ImageCreate ( 24, 24, RGBA ( 0, 0, 0, 0 ), 32 )	

			Gfx_Buffer_Stretch_Aspect ( DispOut ( Index, Pg_Illustration ), Intermediary )
		
			Gfx_Buffer_Inlay Intermediary, DispOut ( Index, Pg_Thumbnail )
		
		End If
		
		Xo = ( ( Index ) Mod ( DispOut ( 0, Pg_Gallery ) - > Width \ 24 ) ) * 24
			
		Yo = ( ( Index ) \ ( DispOut ( 0, Pg_Gallery ) - > Width \ 24 ) ) * 24
			
		Put DispOut ( 0, Pg_Gallery ), ( Xo, Yo ), DispOut ( Index, Pg_Thumbnail ), Alpha
				
	Next Index
	
End Sub